/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.cms.type;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardException;
import kz.gov.pki.cms.BundleLog;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.KeyStoreUtil;

public class StorageInfo {
    private String alias;
    private String container;
    private String password;
    private KeyStore keyStore;
    private Storage storage;
    private List<String> containers;

    public StorageInfo(String storageName) {
        this.storage = Storage.get((String)storageName);
    }

    public List<String> getContainers() {
        if ((this.containers == null || this.containers.isEmpty()) && this.storage != null && this.storage.isToken()) {
            if (this.containers == null) {
                this.containers = new ArrayList<String>();
            }
            try {
                for (String tName : KeyStoreUtil.loadSlotList((Storage)this.storage)) {
                    this.containers.add(tName);
                }
            }
            catch (CardException | KalkanException | ProviderUtilException e) {
                BundleLog.LOG.error(e.getMessage(), e);
            }
        }
        return this.containers;
    }

    public String getAlias() {
        return this.alias;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public char[] getPassword() {
        return this.password != null ? this.password.toCharArray() : null;
    }

    public void setPassword(String password) {
        this.password = password != null ? password.trim() : null;
    }
}

