/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.cms.fx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.KeyStore;
import java.security.Provider;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.HTMLEditor;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import kz.gov.pki.cms.BundleLog;
import kz.gov.pki.cms.BundleProvider;
import kz.gov.pki.cms.exception.ClientException;
import kz.gov.pki.cms.type.FileExtension;
import kz.gov.pki.cms.type.StorageInfo;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KeyStoreEntry;

public class JavaFXThread {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    Font font = new Font("Arial", 15.0);
    Locale locale;

    public JavaFXThread(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void fillStorageInfo(StorageInfo storageInfo) {
        Stage stage = new Stage();
        VBox vBox = this.buildStage(stage);
        GridPane gridPane = this.createFormPane();
        this.addUIControls(gridPane, stage, storageInfo);
        vBox.getChildren().addAll((Object[])new Node[]{gridPane});
        stage.showAndWait();
    }

    private void addUIControls(GridPane gridPane, Stage stage, StorageInfo storageInfo) {
        Label headerLabel = new Label(this.getMessage("storage"));
        headerLabel.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)24.0));
        gridPane.add((Node)headerLabel, 0, 0, 2, 1);
        GridPane.setHalignment((Node)headerLabel, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)headerLabel, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        Label nameLabel = new Label(this.getMessage("storage.path"));
        gridPane.add((Node)nameLabel, 0, 1);
        if (storageInfo.getStorage().isToken()) {
            ObservableList options = FXCollections.observableArrayList(storageInfo.getContainers());
            ComboBox containerComboBox = new ComboBox(options);
            containerComboBox.setOnAction(e -> storageInfo.setContainer((String)containerComboBox.getSelectionModel().getSelectedItem()));
            containerComboBox.getSelectionModel().selectFirst();
            storageInfo.setContainer((String)containerComboBox.getSelectionModel().getSelectedItem());
            gridPane.add((Node)containerComboBox, 1, 1);
        } else {
            TextField containerField = new TextField();
            containerField.setDisable(true);
            Button fileBtn = new Button(this.getMessage("btn.choose") + "..");
            fileBtn.setOnAction(e -> {
                File f = this.getFile("", FileExtension.pkcs12, stage);
                if (f != null) {
                    containerField.setText(f.getPath());
                    storageInfo.setContainer(f.getPath());
                }
            });
            HBox hb = new HBox();
            hb.setSpacing(1.0);
            hb.getChildren().addAll((Object[])new Node[]{containerField, fileBtn});
            HBox.setHgrow((Node)containerField, (Priority)Priority.ALWAYS);
            gridPane.add((Node)hb, 1, 1);
        }
        Label passwordLabel = new Label(this.getMessage("pwd"));
        gridPane.add((Node)passwordLabel, 0, 2);
        PasswordField passwordField = new PasswordField();
        gridPane.add((Node)passwordField, 1, 2);
        Button submitButton = new Button(this.getMessage("open"));
        submitButton.setDefaultButton(true);
        submitButton.setPrefWidth(100.0);
        gridPane.add((Node)submitButton, 0, 3, 2, 1);
        GridPane.setHalignment((Node)submitButton, (HPos)HPos.CENTER);
        GridPane.setMargin((Node)submitButton, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        submitButton.setOnAction(e -> {
            storageInfo.setPassword(passwordField.getText());
            if (storageInfo.getContainer() == null || storageInfo.getPassword() == null || storageInfo.getPassword().length == 0) {
                this.showAlert(Alert.AlertType.ERROR, (Window)stage, this.getMessage("error"), this.getMessage("error.empty"));
                return;
            }
            try {
                storageInfo.setKeyStore(this.getKeyStore(storageInfo));
            }
            catch (Exception exception) {
                this.showAlert(Alert.AlertType.ERROR, (Window)stage, this.getMessage("error"), exception.getMessage());
                return;
            }
            stage.close();
        });
    }

    private KeyStore getKeyStore(StorageInfo storageInfo) throws Exception {
        try {
            return KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                String msg = this.getMessage("pwd.wrongPin");
                if (e.getTryCount() > -1) {
                    msg = msg + " " + this.getMessage("pwd.retryCount") + " " + String.valueOf(e.getTryCount());
                }
                throw new ClientException(msg);
            }
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD)) {
                throw new ClientException(this.getMessage("pwd.blocked"));
            }
            throw new ClientException(e.getMessage());
        }
    }

    private void showAlert(Alert.AlertType alertType, Window owner, String title, String message) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.initOwner(owner);
        alert.show();
    }

    private GridPane createFormPane() {
        GridPane gridPane = new GridPane();
        gridPane.setAlignment(Pos.CENTER);
        gridPane.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        ColumnConstraints columnOneConstraints = new ColumnConstraints(150.0, 150.0, Double.MAX_VALUE);
        columnOneConstraints.setHalignment(HPos.RIGHT);
        ColumnConstraints columnTwoConstrains = new ColumnConstraints(200.0, 200.0, Double.MAX_VALUE);
        columnTwoConstrains.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnOneConstraints, columnTwoConstrains});
        return gridPane;
    }

    private VBox buildStage(Stage stage) {
        stage.setAlwaysOnTop(true);
        JavaFXThread.setIcon(stage);
        stage.setTitle("EzSigner");
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Group root = new Group();
        BorderPane borderPane = new BorderPane();
        BorderPane.setMargin((Node)vbox, (Insets)new Insets(20.0, 5.0, 15.0, 5.0));
        borderPane.setCenter((Node)vbox);
        Scene scene = new Scene((Parent)root, 500.0, 250.0);
        scene.setRoot((Parent)borderPane);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.centerOnScreen();
        return vbox;
    }

    public Optional<String> keyChooser(Collection<Map.Entry<String, KeyStoreEntry>> certificates) {
        String[] result = new String[]{null};
        Dialog dialog = new Dialog();
        dialog.setTitle(this.getMessage("key.list"));
        dialog.setHeaderText(this.getMessage("key.choose"));
        dialog.setGraphic((Node)new ImageView(JavaFXThread.class.getResource("/password_icon.png").toString()));
        ButtonType chooseButtonType = new ButtonType(this.getMessage("btn.choose"), ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{chooseButtonType, ButtonType.CANCEL});
        Label mainLabel = new Label(this.getMessage("chooseKey"));
        mainLabel.setFont(this.font);
        ListView listView = new ListView(FXCollections.observableArrayList((Collection)certificates.stream().filter(m -> m.getValue() != null && ((KeyStoreEntry)m.getValue()).getSubjectCn() != null).collect(Collectors.toList())));
        listView.setCellFactory(param -> new ListCell<Map.Entry<String, KeyStoreEntry>>(){

            protected void updateItem(Map.Entry<String, KeyStoreEntry> item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || item.getKey() == null || item.getValue().getSubjectCn() == null) {
                    this.setText(null);
                } else {
                    KeyStoreEntry keyStoreEntry = item.getValue();
                    Label keyDn = new Label(JavaFXThread.this.getMessage("key.dn") + ": " + keyStoreEntry.getSubjectCn());
                    keyDn.setFont(JavaFXThread.this.font);
                    Label keyAlgorithm = new Label(JavaFXThread.this.getMessage("key.algorithm") + ": " + JavaFXThread.this.getMessage("key.sign"));
                    keyAlgorithm.setFont(JavaFXThread.this.font);
                    Label keySerial = new Label(JavaFXThread.this.getMessage("key.serial") + ": " + keyStoreEntry.getKeyId());
                    keySerial.setFont(JavaFXThread.this.font);
                    Label certPeriod = new Label(JavaFXThread.this.getMessage("cert.period") + ": " + JavaFXThread.this.simpleDateFormat.format(keyStoreEntry.getX509Certificate().getNotBefore()) + " - " + JavaFXThread.this.simpleDateFormat.format(keyStoreEntry.getX509Certificate().getNotAfter()));
                    certPeriod.setFont(JavaFXThread.this.font);
                    VBox vbox = new VBox();
                    vbox.setSpacing(5.0);
                    vbox.setPadding(new Insets(5.0, 3.0, 10.0, 3.0));
                    vbox.getChildren().addAll((Object[])new Node[]{keyDn, keyAlgorithm, keySerial, certPeriod});
                    this.setGraphic((Node)vbox);
                }
            }
        });
        listView.getSelectionModel().select(0);
        listView.setMinSize(550.0, 250.0);
        dialog.getDialogPane().setContent((Node)listView);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == chooseButtonType) {
                return (String)((Map.Entry)listView.getSelectionModel().getSelectedItem()).getKey();
            }
            return null;
        });
        return dialog.showAndWait();
    }

    public File getFile(String initialFilePath, FileExtension fileExtension) {
        Stage stage = this.showTransporentStage();
        File f = this.getFile(initialFilePath, fileExtension, stage);
        stage.close();
        return f;
    }

    public File getFile(String initialFilePath, FileExtension fileExtension, Stage stage) {
        File initialDir;
        FileChooser fileChooser = new FileChooser();
        if (fileExtension != null && !fileExtension.equals((Object)FileExtension.all)) {
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(fileExtension.getDesc(), fileExtension.getExts());
            fileChooser.getExtensionFilters().add((Object)extFilter);
        }
        if (initialFilePath != null && !initialFilePath.trim().isEmpty() && Files.exists((initialDir = new File(initialFilePath)).toPath(), new LinkOption[0])) {
            fileChooser.setInitialDirectory(initialDir);
        }
        fileChooser.setTitle(this.getMessage("key.choose"));
        return fileChooser.showOpenDialog((Window)stage);
    }

    public File getDirectoryPath(String initialFilePath) {
        File initialDir;
        DirectoryChooser dirChooser = new DirectoryChooser();
        dirChooser.setTitle(this.getMessage("dir.choose"));
        if (initialFilePath != null && !initialFilePath.trim().isEmpty() && Files.exists((initialDir = new File(initialFilePath)).toPath(), new LinkOption[0])) {
            dirChooser.setInitialDirectory(initialDir);
        }
        Stage stage = this.showTransporentStage();
        File f = dirChooser.showDialog((Window)stage);
        stage.close();
        return f;
    }

    private Stage showTransporentStage() {
        Stage stage = new Stage();
        stage.setWidth(10.0);
        stage.setHeight(10.0);
        stage.setAlwaysOnTop(true);
        JavaFXThread.setIcon(stage);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.centerOnScreen();
        stage.show();
        return stage;
    }

    public String showEditor(String htmlText) {
        String[] result = new String[]{null};
        AnchorPane anchor = new AnchorPane();
        HTMLEditor htmlEditor = new HTMLEditor();
        AnchorPane.setTopAnchor((Node)htmlEditor, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)htmlEditor, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)htmlEditor, (Double)0.0);
        AnchorPane.setRightAnchor((Node)htmlEditor, (Double)0.0);
        htmlEditor.setPrefHeight(350.0);
        htmlEditor.setStyle("-fx-font: 12 cambria;-fx-border-color: brown; -fx-border-width: 1;");
        htmlEditor.setHtmlText(htmlText);
        anchor.getChildren().addAll((Object[])new Node[]{htmlEditor});
        DialogPane dialogPane = new DialogPane();
        dialogPane.getButtonTypes().add((Object)ButtonType.OK);
        dialogPane.getButtonTypes().add((Object)ButtonType.CANCEL);
        Button okButton = (Button)dialogPane.lookupButton(ButtonType.OK);
        okButton.setDefaultButton(false);
        dialogPane.setContent((Node)anchor);
        Dialog dialog = new Dialog();
        dialog.setDialogPane(dialogPane);
        dialog.setResizable(true);
        dialog.showAndWait().ifPresent(res -> {
            if (res == ButtonType.OK) {
                result[0] = htmlEditor.getHtmlText();
            }
        });
        return result[0];
    }

    private static void setIcon(Stage stage) {
        try {
            URL url = JavaFXThread.class.getResource("/icon.png");
            if (url != null) {
                InputStream is = url.openStream();
                stage.getIcons().add((Object)new Image(is));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getMessage(String key) {
        return ResourceBundle.getBundle("i18n/UILanguage", this.locale).getString(key);
    }
}

