/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.cms;

import java.lang.reflect.Method;
import java.util.Hashtable;
import kz.gov.pki.cms.BundleLog;
import kz.gov.pki.cms.BundleProvider;
import kz.gov.pki.cms.CMSSignUtil;
import kz.gov.pki.cms.type.ResponseForJS;
import kz.gov.pki.osgi.layer.api.ModuleService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class NLDocSignerActivator
implements BundleActivator {
    private static final int[] ARRAY_INT = new int[0];
    private static final String[] ARRAY_STRING = new String[0];

    public void start(BundleContext bundleContext) throws Exception {
        try {
            BundleProvider.KALKAN.discoverProviderService();
            BundleLog.LOG.discoverLogService();
            this.registerService(bundleContext);
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new Exception("Can not start bundle NLDocSigner!");
        }
    }

    private void registerService(BundleContext context) {
        CMSSignUtil cmsSignUtil = new CMSSignUtil();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("module", "kz.gov.pki.cms.CMSSignUtil");
        ServiceRegistration serviceRegistration = context.registerService(ModuleService.class.getName().toString(), (jsonString, headers) -> {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                String uuid = jsonObject.optString("uuid");
                String mname = jsonObject.getString("method");
                JSONArray args = jsonObject.optJSONArray("args");
                String lang = jsonObject.optString("lang");
                int argLen = args != null ? args.length() : 0;
                Method method = null;
                if (!mname.isEmpty()) {
                    Method[] ms;
                    for (Method m : ms = cmsSignUtil.getClass().getDeclaredMethods()) {
                        if (!m.getName().equals(mname) || m.getParameterTypes().length != argLen) continue;
                        method = m;
                        break;
                    }
                }
                if (method != null) {
                    Object[] argObjs = null;
                    if (argLen > 0) {
                        argObjs = new Object[argLen];
                    }
                    for (int i = 0; i < argLen; ++i) {
                        Object objArg = args.get(i);
                        if (objArg instanceof JSONArray) {
                            int j;
                            Object[] arrayArg;
                            JSONArray arrayObj = (JSONArray)objArg;
                            if (method.getParameterTypes()[i].isInstance(ARRAY_INT)) {
                                arrayArg = new int[arrayObj.length()];
                                for (j = 0; j < arrayArg.length; ++j) {
                                    arrayArg[j] = arrayObj.getInt(j);
                                }
                                argObjs[i] = arrayArg;
                                continue;
                            }
                            if (method.getParameterTypes()[i].isInstance(ARRAY_STRING)) {
                                arrayArg = new String[arrayObj.length()];
                                for (j = 0; j < arrayArg.length; ++j) {
                                    arrayArg[j] = (int)arrayObj.getString(j);
                                }
                                argObjs[i] = arrayArg;
                                continue;
                            }
                            arrayArg = new Object[arrayObj.length()];
                            for (j = 0; j < arrayArg.length; ++j) {
                                arrayArg[j] = (int)arrayObj.get(j);
                            }
                            argObjs[i] = arrayArg;
                            continue;
                        }
                        argObjs[i] = objArg;
                    }
                    String jsonResult = null;
                    try {
                        cmsSignUtil.changeLang(lang);
                        jsonResult = (String)method.invoke((Object)cmsSignUtil, argObjs);
                    }
                    catch (Exception e) {
                        BundleLog.LOG.error(e.getMessage(), e);
                        return this.getErrorResponse(e + ". Method: " + mname);
                    }
                    if (uuid.isEmpty()) {
                        return jsonResult;
                    }
                    JSONObject resultObject = new JSONObject(jsonResult);
                    return resultObject.put("uuid", (Object)uuid).toString();
                }
                return this.getErrorResponse(cmsSignUtil.getMessage("module.NoSuchMethodException") + " " + mname);
            }
            catch (Exception e) {
                BundleLog.LOG.error(e.getMessage(), e);
                return this.getErrorResponse(e.getMessage());
            }
        }, props);
    }

    private String getErrorResponse(String msg) {
        ResponseForJS responseForJS = new ResponseForJS("500");
        responseForJS.setMessage(msg);
        return ((JSONObject)JSONObject.wrap(responseForJS)).toString();
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

