/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.cms;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javax.security.auth.x500.X500Principal;
import kz.gov.pki.cms.BundleLog;
import kz.gov.pki.cms.BundleProvider;
import kz.gov.pki.cms.KNCAOCSPChecker;
import kz.gov.pki.cms.exception.ClientException;
import kz.gov.pki.cms.fx.JavaFXThread;
import kz.gov.pki.cms.type.FileExtension;
import kz.gov.pki.cms.type.FileInfo;
import kz.gov.pki.cms.type.ResponseForJS;
import kz.gov.pki.cms.type.SignerInfo;
import kz.gov.pki.cms.type.StorageInfo;
import kz.gov.pki.cms.type.VerificationResult;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.OCSPCode;
import kz.gov.pki.kalkan.jce.exception.ExtCertPathValidatorException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.TSPUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.provider.utils.verifier.VerifierFlags;
import kz.gov.pki.provider.utils.verifier.VerifyCMSSignatureResult;
import kz.gov.pki.provider.utils.verifier.VerifyX509CertifcateResult;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.KeyStoreEntry;
import kz.gov.pki.reference.TSAPolicy;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public class CMSSignUtil {
    private JavaFXThread javaFXThread;
    private Locale locale;
    private Locale locale_ru = new Locale("ru");
    private Locale locale_kk = new Locale("kk");
    private Collection<X509Certificate> caCertList;
    private Map<X500Principal, X509Certificate> caCertsMap;
    VerifierFlags sigVerifierFlags = new VerifierFlags("SIGNATURE");
    DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public CMSSignUtil() {
        this.locale = this.locale_ru;
        this.javaFXThread = new JavaFXThread(this.locale);
    }

    public String showKeyChooser(Collection<Map.Entry<String, KeyStoreEntry>> list) {
        String[] result = new String[]{null};
        CountDownLatch readyLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            this.javaFXThread.keyChooser(list).ifPresent(r -> {
                result[0] = r;
            });
            readyLatch.countDown();
        });
        try {
            readyLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result[0];
    }

    public void changeLang(String lang) {
        this.locale = lang.equals("kk") ? this.locale_kk : this.locale_ru;
        this.javaFXThread.setLocale(this.locale);
    }

    public String getDirectoryPath(String initialPath) throws InterruptedException {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("200");
        File d = this.getDirectory(initialPath);
        if (d != null) {
            responseForJS.setResponseObject(d.getPath());
        }
        return this.getJson(responseForJS);
    }

    public String getFilePath(String fileExt, String initialPath) throws InterruptedException {
        FileExtension fileExtension = FileExtension.valueOf(fileExt);
        File[] f = new File[1];
        CountDownLatch readyLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            f[0] = this.javaFXThread.getFile(initialPath, fileExtension);
            readyLatch.countDown();
        });
        readyLatch.await();
        File file = f[0];
        ResponseForJS<FileInfo> responseForJS = new ResponseForJS<FileInfo>("200");
        try {
            if (file != null) {
                FileInfo fileInfo = new FileInfo(file.getPath(), Files.size(file.toPath()));
                fileInfo.setFilename(file.getName());
                fileInfo.setFiledir(file.getParent());
                responseForJS.setResponseObject(fileInfo);
            } else {
                responseForJS.setResponseObject(new FileInfo());
            }
        }
        catch (IOException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            responseForJS.setCode("500");
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String signFileUrl(String fileUrl, String fileDir, String storageInfoJson) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        try {
            if (storageInfoJson == null || storageInfoJson.trim().isEmpty()) {
                throw new ClientException(this.getMessage("404"));
            }
            FileInfo fileInfo = this.getFileFromURL(fileUrl, fileDir);
            responseForJS.setResponseObject(this.sign(fileInfo, storageInfoJson));
            responseForJS.setCode("200");
            responseForJS.setMessage(this.getMessage("cms.signed"));
        }
        catch (ClientException e) {
            responseForJS.setMessage(e.getMessage());
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String signFile(String filePath, String fileUrl, String fileDir, String storageInfoJson) {
        if (filePath != null && !filePath.isEmpty()) {
            return this.signFilePath(filePath, fileDir, storageInfoJson);
        }
        return this.signFileUrl(fileUrl, fileDir, storageInfoJson);
    }

    public String signFilePath(String filePath, String fileDir, String storageInfoJson) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        try {
            if (storageInfoJson == null || storageInfoJson.trim().isEmpty()) {
                throw new ClientException(this.getMessage("404"));
            }
            FileInfo fileInfo = this.getFileFromPath(filePath, fileDir);
            responseForJS.setResponseObject(this.sign(fileInfo, storageInfoJson));
            responseForJS.setCode("200");
            responseForJS.setMessage(this.getMessage("cms.signed"));
        }
        catch (ClientException e) {
            responseForJS.setMessage(e.getMessage());
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String signFileText(String fileText, String fileDir, String storageInfoJson) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        try {
            if (fileText == null || fileText.trim().isEmpty() || fileDir == null || fileDir.trim().isEmpty() || storageInfoJson == null || storageInfoJson.trim().isEmpty()) {
                throw new ClientException(this.getMessage("404"));
            }
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFiledir(fileDir);
            fileInfo.setBytes(fileText.getBytes("utf8"));
            responseForJS.setResponseObject(this.sign(fileInfo, storageInfoJson));
            responseForJS.setCode("200");
            responseForJS.setMessage(this.getMessage("cms.signed"));
        }
        catch (ClientException e) {
            responseForJS.setMessage(e.getMessage());
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String checkCMS(String filePath) {
        ResponseForJS responseForJS = new ResponseForJS("500");
        try {
            FileInfo fileInfo = this.getFileFromPath(filePath);
            List<SignerInfo> listSignerInfo = this.verifyCMSResult(fileInfo.getBytes());
            responseForJS.setCode("200");
            responseForJS.setResponseObjects(listSignerInfo.toArray());
        }
        catch (ClientException e) {
            responseForJS.setMessage(e.getMessage());
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String saveCMS(String filePath, String fileDir) {
        ResponseForJS<FileInfo> responseForJS = new ResponseForJS<FileInfo>("500");
        try {
            Path forCheck = Paths.get(filePath, new String[0]);
            CMSSignedData cmsSignedData = CMSUtil.parseAsCMS((byte[])this.getBytes(forCheck));
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                cmsSignedData.getSignedContent().write((OutputStream)byteArrayOutputStream);
                Path dir = Paths.get(fileDir, new String[0]);
                if (Files.exists(dir, new LinkOption[0])) {
                    String fName = this.getOriginalFileName(forCheck.getFileName().toString());
                    Path newFile = this.getFreeFileName(dir.resolve(fName));
                    Files.write(newFile, byteArrayOutputStream.toByteArray(), new OpenOption[0]);
                    FileInfo fileInfo = new FileInfo(newFile.toString(), Files.size(newFile));
                    fileInfo.setFilename(newFile.getFileName().toString());
                    fileInfo.setFiledir(newFile.getParent().toString());
                    responseForJS.setCode("200");
                    responseForJS.setMessage(this.getMessage("file.saved"));
                    responseForJS.setResponseObject(fileInfo);
                } else {
                    responseForJS.setMessage(this.getMessage("404"));
                }
            }
        }
        catch (Exception e) {
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String getHtmlEditorText(final String text) {
        ResponseForJS<String> responseForJS = new ResponseForJS<String>("500");
        try {
            final String[] result = new String[]{null};
            final CountDownLatch readyLatch = new CountDownLatch(1);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    result[0] = CMSSignUtil.this.javaFXThread.showEditor(text);
                    readyLatch.countDown();
                }
            });
            readyLatch.await();
            responseForJS.setCode("200");
            responseForJS.setResponseObject(result[0]);
        }
        catch (Exception e) {
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    public String openFileinOS(String filePath) {
        ResponseForJS responseForJS = new ResponseForJS("500");
        try {
            if (Desktop.isDesktopSupported() && !GraphicsEnvironment.isHeadless()) {
                File myFile = new File(filePath);
                if (Files.exists(myFile.toPath(), new LinkOption[0])) {
                    Desktop.getDesktop().open(myFile);
                    responseForJS.setCode("200");
                } else {
                    responseForJS.setMessage(this.getMessage("404"));
                }
            } else {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.startsWith("Linux") || osName.startsWith("LINUX") || osName.startsWith("Mac OS X") || osName.startsWith("Solaris")) {
                        Runtime.getRuntime().exec(new String[]{"edit", filePath});
                    } else if (osName.startsWith("Windows")) {
                        Process process = new ProcessBuilder("explorer.exe", "/select," + filePath).start();
                    } else if (osName.startsWith("Mac")) {
                        Runtime.getRuntime().exec(new String[]{"open", "-a", "Microsoft Word", filePath});
                    }
                }
            }
        }
        catch (Exception e) {
            responseForJS.setMessage(this.getMessage("internalError"));
        }
        return this.getJson(responseForJS);
    }

    private List<SignerInfo> verifyCMSResult(byte[] bytes) throws ClientException {
        ArrayList<SignerInfo> signerInfos = new ArrayList<SignerInfo>();
        CMSSignedData cms = null;
        try {
            cms = CMSUtil.parseAsCMS((byte[])bytes);
        }
        catch (CMSException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("cms.exception"));
        }
        CertStore certs = null;
        try {
            certs = cms.getCertificatesAndCRLs("Collection", BundleProvider.KALKAN.getProvider().getName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CMSException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("cms.process.exception"));
        }
        Iterator it = cms.getSignerInfos().getSigners().iterator();
        while (it.hasNext()) {
            SignerInfo signerInfo = new SignerInfo();
            SignerInformation signer = (SignerInformation)it.next();
            Collection<? extends Certificate> certCollection = null;
            try {
                certCollection = certs.getCertificates((CertSelector)signer.getSID());
            }
            catch (CertStoreException e) {
                BundleLog.LOG.error(e.getMessage(), e);
                throw new ClientException(this.getMessage("cms.process.exception"));
            }
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            if (certIt.hasNext()) {
                VerificationResult certVR;
                X509Certificate cert;
                block26: {
                    cert = (X509Certificate)certIt.next();
                    this.fillFromCert(signerInfo, cert);
                    Date sign_date = null;
                    TimeStampToken tsToken = null;
                    try {
                        tsToken = CMSUtil.getTimestampToken((SignerInformation)signer, (Provider)BundleProvider.KALKAN.getProvider());
                    }
                    catch (Exception e) {
                        BundleLog.LOG.error(e.getMessage(), e);
                        throw new ClientException(this.getMessage("cms.process.exception"));
                    }
                    if (tsToken != null) {
                        try {
                            sign_date = tsToken.getTimeStampInfo().getGenTime();
                            signerInfo.setTspDate(this.df.format(sign_date));
                            TSPUtil.validateTimeStampToken((TimeStampToken)tsToken, (byte[])signer.getSignature(), (Provider)BundleProvider.KALKAN.getProvider());
                            signerInfo.setTspVerificationResult(new VerificationResult(true));
                        }
                        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertStoreException | CMSException e) {
                            BundleLog.LOG.error(e.getMessage(), e);
                            throw new ClientException(this.getMessage("cms.process.exception"));
                        }
                        catch (CertificateExpiredException | CertificateNotYetValidException | TSPException | ProviderUtilException e) {
                            BundleLog.LOG.error(e.getMessage(), e);
                            signerInfo.setTspVerificationResult(new VerificationResult(false, this.getMessage("tsp.verification.error")));
                        }
                    } else {
                        signerInfo.setTspVerificationResult(new VerificationResult(false, this.getMessage("tsp.notFound")));
                    }
                    certVR = this.verifyCert(cert, false, sign_date);
                    Date date = sign_date = sign_date == null ? new Date() : sign_date;
                    if (certVR.isValid()) {
                        try {
                            KNCAOCSPChecker checker = new KNCAOCSPChecker(this.getCaCertsMap());
                            checker.check(cert);
                        }
                        catch (CertPathValidatorException e) {
                            Date revokeDate;
                            if (!(e.getCause() instanceof KalkanException)) break block26;
                            KalkanException ke = (KalkanException)e.getCause();
                            if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED) && (revokeDate = (Date)ke.get("time")).before(sign_date)) {
                                certVR = new VerificationResult(false, this.getMessage("ocsp.revoked"));
                            }
                            if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                                certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.unknown"));
                            }
                            if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                                certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.nonces"));
                            }
                            if (ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) {
                                certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.not_verified"));
                            }
                            if (!ke.getErrorCode().equals(OCSPCode.THIS_UPDATE_NOT_SATISFIED) && !ke.getErrorCode().equals(OCSPCode.NEXT_UPDATE_NOT_SATISFIED) && !ke.getErrorCode().equals(OCSPCode.ALLOWED_PERIOD_NOT_SATISFIED)) break block26;
                            certVR = new VerificationResult(false, this.getMessage("ocsp.exception"));
                        }
                    }
                }
                signerInfo.setCertificateVerificationResult(certVR);
                try {
                    signerInfo.setSignatureVerificationResult(new VerificationResult(signer.verify(cert, BundleProvider.KALKAN.getProvider().getName())));
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    BundleLog.LOG.error(e.getMessage(), e);
                    signerInfo.setSignatureVerificationResult(new VerificationResult(false, this.getMessage("sign.validity.cert.invalid")));
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException | CMSException e) {
                    BundleLog.LOG.error(e.getMessage(), e);
                    throw new ClientException(this.getMessage("cms.process.exception"));
                }
            } else {
                signerInfo.setCertificateVerificationResult(new VerificationResult(false, this.getMessage("cms.cert.404")));
            }
            signerInfo.setValidSignature(signerInfo.getSignatureVerificationResult().isValid() && signerInfo.getCertificateVerificationResult().isValid() && signerInfo.getTspVerificationResult().isValid());
            signerInfos.add(signerInfo);
        }
        return signerInfos;
    }

    private VerificationResult verifyCert(X509Certificate cert, boolean ocsp, Date checkDate) throws ClientException {
        try {
            if (!X509Util.getKNCACertificateType((X509Certificate)cert).contains(KNCACertificateType.SIGNATURE)) {
                return new VerificationResult(false, this.getMessage("error.certificate.type"));
            }
            try {
                PKIXUtil pkixUtil = new PKIXUtil(cert, this.getCaCertList());
                if (ocsp) {
                    pkixUtil = pkixUtil.withOCSP();
                }
                if (checkDate != null) {
                    pkixUtil.withDate(checkDate);
                }
                pkixUtil.validate();
            }
            catch (ProviderUtilException pue) {
                CertPathBuilderException e;
                BundleLog.LOG.error(pue.getMessage(), pue);
                if (pue.getCause() != null && pue.getCause() instanceof CertPathBuilderException && (e = (CertPathBuilderException)pue.getCause()).getCause() != null && e.getCause() instanceof ExtCertPathValidatorException) {
                    CertPathValidatorException eee;
                    ExtCertPathValidatorException ee = (ExtCertPathValidatorException)e.getCause();
                    if (ee.getCause() != null && ee.getCause() instanceof CertificateExpiredException) {
                        return new VerificationResult(false, this.getMessage("cert.expired"));
                    }
                    if (ee.getCause() != null && ee.getCause() instanceof CertificateNotYetValidException) {
                        return new VerificationResult(false, this.getMessage("cert.not_yet_valid"));
                    }
                    if (ee.getCause() != null && ee.getCause() instanceof CertPathValidatorException && (eee = (CertPathValidatorException)ee.getCause()).getCause() != null && eee.getCause() instanceof KalkanException) {
                        KalkanException ke = (KalkanException)eee.getCause();
                        if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED)) {
                            return new VerificationResult(false, this.getMessage("ocsp.revoked"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                            return new VerificationResult(false, this.getMessage("error.certificate.ocsp.unknown"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                            return new VerificationResult(false, this.getMessage("error.certificate.ocsp.nonces"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) {
                            return new VerificationResult(false, this.getMessage("error.certificate.ocsp.not_verified"));
                        }
                        if (ke.getErrorCode().equals(OCSPCode.THIS_UPDATE_NOT_SATISFIED) || ke.getErrorCode().equals(OCSPCode.NEXT_UPDATE_NOT_SATISFIED) || ke.getErrorCode().equals(OCSPCode.ALLOWED_PERIOD_NOT_SATISFIED)) {
                            return new VerificationResult(false, this.getMessage("ocsp.exception"));
                        }
                    }
                    if (ee.getCause() != null && ee.getCause() instanceof InvalidKeyException) {
                        return new VerificationResult(false, this.getMessage("error.certificate.ca"));
                    }
                }
                if (pue.getCode().equals((Object)ProviderUtilExceptionCode.ISSUER_CERT_NOT_FOUND)) {
                    return new VerificationResult(false, this.getMessage("error.certificate.ca"));
                }
                return new VerificationResult(false, pue.getCode().toString());
            }
            if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.5.19.1.2.2.1.2") || X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.5.19.1.2.2.1")) {
                return new VerificationResult(false, this.getMessage("cert.verification.error"));
            }
            return new VerificationResult(true);
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("cert.process.exception"));
        }
    }

    private Throwable getMainException(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            return this.getMainException(cause);
        }
        return throwable;
    }

    private String sign(FileInfo fileInfo, String storageName) throws Exception {
        if (storageName == null || storageName.isEmpty()) {
            throw new ClientException(this.getMessage("invalid.param"));
        }
        StorageInfo storageInfo = this.getStorageInfo(storageName);
        Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)KNCACertificateType.SIGNATURE, (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        if (keyStoreEntries.size() > 0) {
            String alias = null;
            if (keyStoreEntries.size() > 1) {
                alias = this.showKeyChooser(keyStoreEntries.entrySet());
            } else {
                Iterator iterator = keyStoreEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    alias = key = (String)iterator.next();
                }
            }
            if (alias != null) {
                this.checkCert(((KeyStoreEntry)keyStoreEntries.get(alias)).getX509Certificate());
                CMSSignedData cmsSignedData = this.createCAdES(storageInfo.getKeyStore(), alias, storageInfo.getPassword(), fileInfo.getBytes());
                return this.saveFile(cmsSignedData, fileInfo.getFilename(), fileInfo.getFiledir());
            }
            throw new ClientException(this.getMessage("action.canceled"));
        }
        throw new ClientException(this.getMessage("keyNotFound"));
    }

    private StorageInfo getStorageInfo(String name) throws ClientException {
        StorageInfo storageInfo = new StorageInfo(name);
        if (storageInfo.getStorage().isToken() && storageInfo.getContainers().size() == 0) {
            throw new ClientException("\u041d\u043e\u0441\u0438\u0442\u0435\u043b\u044c \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d");
        }
        CountDownLatch readyLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            this.javaFXThread.fillStorageInfo(storageInfo);
            readyLatch.countDown();
        });
        try {
            readyLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (storageInfo.getKeyStore() == null) {
            throw new ClientException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435");
        }
        return storageInfo;
    }

    private void checkCert(X509Certificate cert) throws ClientException {
        VerificationResult certVR;
        block8: {
            certVR = this.verifyCert(cert, false, null);
            if (certVR.isValid()) {
                try {
                    KNCAOCSPChecker checker = new KNCAOCSPChecker(this.getCaCertsMap());
                    checker.check(cert);
                }
                catch (CertPathValidatorException e) {
                    if (!(e.getCause() instanceof KalkanException)) break block8;
                    KalkanException ke = (KalkanException)e.getCause();
                    if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED)) {
                        certVR = new VerificationResult(false, this.getMessage("ocsp.revoked"));
                    }
                    if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                        certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.unknown"));
                    }
                    if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                        certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.nonces"));
                    }
                    if (ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) {
                        certVR = new VerificationResult(false, this.getMessage("error.certificate.ocsp.not_verified"));
                    }
                    if (!ke.getErrorCode().equals(OCSPCode.THIS_UPDATE_NOT_SATISFIED) && !ke.getErrorCode().equals(OCSPCode.NEXT_UPDATE_NOT_SATISFIED) && !ke.getErrorCode().equals(OCSPCode.ALLOWED_PERIOD_NOT_SATISFIED)) break block8;
                    certVR = new VerificationResult(false, this.getMessage("ocsp.exception"));
                }
            }
        }
        if (!certVR.isValid()) {
            throw new ClientException(certVR.getMessage());
        }
    }

    private String saveFile(CMSSignedData cmsSignedData, String fileName, String fileDir) throws ClientException {
        try {
            Path signedFile = null;
            try {
                signedFile = Paths.get(fileDir + FileSystems.getDefault().getSeparator() + fileName + (fileName.endsWith(".cms") ? "" : ".cms"), new String[0]);
            }
            catch (InvalidPathException e) {
                BundleLog.LOG.error(e.getMessage(), e);
                signedFile = Paths.get(fileDir + FileSystems.getDefault().getSeparator() + "signedCMS.cms", new String[0]);
            }
            Files.write(signedFile, cmsSignedData.getEncoded(), new OpenOption[0]);
            return signedFile.toAbsolutePath().toString();
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("file.ioException"));
        }
    }

    private CMSSignedData createCAdES(KeyStore keyStore, String alias, char[] passwrd, byte[] fileBytes) throws Exception {
        try {
            SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)keyStore, (String)alias, (char[])passwrd);
            CMSSignedData cmsSignedData = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])fileBytes, (boolean)true, (Provider)BundleProvider.KALKAN.getProvider());
            TSAProfile tsaProfile = new TSAProfile();
            tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
            tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
            tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
            cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKAN.getProvider());
            return cmsSignedData;
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException("\u041e\u0448\u0438\u0431\u043a\u0430. \u041a\u043e\u0434: " + e.getCode().name());
        }
    }

    private FileInfo getFileFromURL(String fileUrl, String fileDir) throws ClientException {
        if (fileUrl == null || fileUrl.trim().isEmpty() || fileDir == null || fileDir.trim().isEmpty()) {
            throw new ClientException(this.getMessage("404"));
        }
        if (!fileUrl.toLowerCase().matches("^\\w+://.*")) {
            fileUrl = "http://" + fileUrl;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFiledir(fileDir);
        try {
            URLConnection connection = new URL(fileUrl).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(30000);
            try (InputStream in = connection.getInputStream();){
                fileInfo.setBytes(IOUtils.toByteArray(in));
            }
            if (fileInfo.getBytes() == null) {
                throw new ClientException(this.getMessage("file.urlException"));
            }
            String raw = connection.getHeaderField("Content-Disposition");
            if (raw != null && raw.indexOf("=") != -1) {
                fileInfo.setFilename(raw.split("=")[1]);
            } else {
                fileInfo.setFilename(FilenameUtils.getName(fileUrl));
            }
            if (fileInfo.getFilename() == null || fileInfo.getFilename().trim().isEmpty()) {
                fileInfo.setFilename("cmsSignedFile");
            }
        }
        catch (MalformedURLException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("file.urlException") + " " + this.getMessage("url.protocol.exception"));
        }
        catch (IOException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("file.urlException"));
        }
        return fileInfo;
    }

    private FileInfo getFileFromPath(String filePath, String fileDir) throws ClientException {
        if (fileDir == null || fileDir.trim().isEmpty()) {
            throw new ClientException(this.getMessage("404"));
        }
        FileInfo fileInfo = this.getFileFromPath(filePath);
        fileInfo.setFiledir(fileDir);
        return fileInfo;
    }

    private FileInfo getFileFromPath(String filePath) throws ClientException {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new ClientException(this.getMessage("404"));
        }
        FileInfo fileInfo = new FileInfo();
        try {
            Path forSign = Paths.get(filePath, new String[0]);
            fileInfo.setBytes(this.getBytes(forSign));
            fileInfo.setFilename(forSign.getFileName().toString());
            if (fileInfo.getBytes() == null) {
                throw new ClientException(this.getMessage("file.ioException"));
            }
        }
        catch (IOException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(this.getMessage("file.ioException"));
        }
        return fileInfo;
    }

    private File getDirectory(String initDir) throws InterruptedException {
        File[] f = new File[1];
        CountDownLatch readyLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            f[0] = this.javaFXThread.getDirectoryPath(initDir);
            readyLatch.countDown();
        });
        readyLatch.await();
        File dir = f[0];
        return dir;
    }

    private String getOriginalFileName(String fileName) {
        if (fileName.endsWith(".cms")) {
            fileName = fileName.substring(0, fileName.length() - ".cms".length());
            return this.getOriginalFileName(fileName);
        }
        return fileName;
    }

    private Path getFreeFileName(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            String newName;
            String fname = file.getFileName().toString();
            fname = fname.contains(".") ? (newName = fname.substring(0, fname.lastIndexOf(".")) + "_1" + fname.substring(fname.lastIndexOf("."))) : fname + "_1";
            file = this.getFreeFileName(file.getParent().resolve(fname));
        }
        return file;
    }

    private Path createFileName(String fDir, String fname) {
        Path signedFile = Paths.get(fDir + FileSystems.getDefault().getSeparator() + fname + ".cms", new String[0]);
        if (Files.exists(signedFile, new LinkOption[0])) {
            return this.createFileName(fDir, fname + "_1");
        }
        return signedFile;
    }

    public String getMessage(String key) {
        return ResourceBundle.getBundle("i18n/UILanguage", this.locale).getString(key);
    }

    public String getJson(Object o) {
        return ((JSONObject)JSONObject.wrap((Object)o)).toString();
    }

    private byte[] getBytes(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            byte[] byArray = IOUtils.toByteArray(in);
            return byArray;
        }
    }

    private List<SignerInfo> getListSignerInfo(Set<VerifyCMSSignatureResult> results) {
        int number = 0;
        ArrayList<SignerInfo> listSignerInfo = new ArrayList<SignerInfo>();
        for (VerifyCMSSignatureResult r : results) {
            SignerInfo si = this.fillSignerInfo(new SignerInfo(), r.getVerifyX509CertifcateResult());
            si.setNumber(++number);
            if (r.getTsToken() != null) {
                si.setTspDate(this.df.format(r.getTsToken().getTimeStampInfo().getGenTime()));
            }
            listSignerInfo.add(si);
        }
        return listSignerInfo;
    }

    private SignerInfo fillSignerInfo(SignerInfo si, VerifyX509CertifcateResult r) {
        String[] g;
        Map map = r.getMapRdnOidValue();
        si.setIin(r.getIin());
        String[] cn = (String[])map.get(X509Name.CN.getId());
        if (cn != null && cn.length > 0) {
            si.setName(cn[0].trim());
        }
        if ((g = (String[])map.get(X509Name.GIVENNAME.getId())) != null && g.length > 0) {
            if (si.getName() != null) {
                si.setName(si.getName() + " " + g[0]);
            } else {
                si.setName(g[0]);
            }
        }
        si.setPersonCertificate(r.isPersonCert());
        if (!r.isPersonCert()) {
            si.setBin(r.getBin());
            String[] o = (String[])map.get(X509Name.O.getId());
            if (o != null && o.length > 0) {
                si.setOrganizationName(o[0]);
            }
        }
        si.setSerialNumber(r.getSerialNumber());
        String notBefore = this.df.format(r.getX509Certificate().getNotBefore());
        String notAfter = this.df.format(r.getX509Certificate().getNotAfter());
        si.setCertificateValidityPeriod(notBefore + " - " + notAfter);
        si.setValidSignature(r.isValid());
        return si;
    }

    private void fillFromCert(SignerInfo signerInfo, X509Certificate cert) {
        String[] g;
        String[] cn;
        X509Name x509Name = new X509Name(cert.getSubjectDN().getName());
        HashMap mapRdnOidValue = X509Util.getRDNMapWithArrayValues((X509Name)x509Name);
        String[] valuesArray = (String[])mapRdnOidValue.get(X509Name.SERIALNUMBER.getId());
        if (valuesArray != null && valuesArray.length > 0) {
            signerInfo.setIin(valuesArray[0].substring(3));
        }
        if ((cn = (String[])mapRdnOidValue.get(X509Name.CN.getId())) != null && cn.length > 0) {
            signerInfo.setName(cn[0].trim());
        }
        if ((g = (String[])mapRdnOidValue.get(X509Name.GIVENNAME.getId())) != null && g.length > 0) {
            if (signerInfo.getName() != null) {
                signerInfo.setName(signerInfo.getName() + " " + g[0]);
            } else {
                signerInfo.setName(g[0]);
            }
        }
        try {
            signerInfo.setPersonCertificate(X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.1"));
        }
        catch (CertificateParsingException e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
        if (!signerInfo.isPersonCertificate()) {
            String[] o;
            String[] valuesArray_OU = (String[])mapRdnOidValue.get(X509Name.OU.getId());
            if (valuesArray_OU != null) {
                for (String value : valuesArray_OU) {
                    if (!value.contains("BIN") && !value.contains("bin") || value.length() != 15) continue;
                    signerInfo.setBin(value.substring(3));
                }
            }
            if ((o = (String[])mapRdnOidValue.get(X509Name.O.getId())) != null && o.length > 0) {
                signerInfo.setOrganizationName(o[0]);
            }
        }
        signerInfo.setSerialNumber(cert.getSerialNumber().toString(16));
        signerInfo.setCertificateValidityPeriod(this.df.format(cert.getNotBefore()) + " - " + this.df.format(cert.getNotAfter()));
    }

    private Collection<X509Certificate> getCaCertList() {
        if (this.caCertList == null) {
            this.caCertList = new ArrayList<X509Certificate>();
            char[] pwd = "knca".toCharArray();
            try (InputStream in = CMSSignUtil.class.getResource("/cacerts.jks").openStream();){
                KeyStore store = KeyStore.getInstance("JKS", BundleProvider.KALKAN.getProvider());
                store.load(in, pwd);
                Enumeration<String> aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)store.getCertificate(alias);
                    if (cert == null) continue;
                    this.caCertList.add(cert);
                }
            }
            catch (Exception x) {
                BundleLog.LOG.error(x.getMessage(), x);
            }
        }
        return this.caCertList;
    }

    private Map<X500Principal, X509Certificate> getCaCertsMap() {
        if (this.caCertsMap == null) {
            this.caCertsMap = new HashMap<X500Principal, X509Certificate>();
            for (X509Certificate X509cert : this.getCaCertList()) {
                this.caCertsMap.put(X509cert.getSubjectX500Principal(), X509cert);
            }
        }
        return this.caCertsMap;
    }
}

